#!/usr/bin/env sage -python

# Set this to True to enable building extensions using Cython.
# Set it to False to build extensions from the CPP file (that
# was previously created using Cython).
# Set it to 'auto' to build with Cython if available, otherwise
# from the CPP file.
# Warning: I can notice some runtime errors with cython 0.15 that disappear with 0.17
#USE_CYTHON = False
USE_CYTHON = 'auto'

#If you don't have QT support, you can disable qcas with:
# USE_QCAS=False
# and define ENABLEQCAS to 0 in giacpy.pxd
USE_QCAS=False
# to use qcas you should create qcas/libqcas.a with:
# qmake libqcas.pro ;make


from glob import *
from sage.env import *
import sys
sys.path.append(SAGE_SRC)


from distutils.core import setup
from distutils.extension import Extension

if USE_CYTHON:
    try:
        from Cython.Distutils import build_ext
    except ImportError:
        if USE_CYTHON=='auto':
            USE_CYTHON=False
        else:
            raise

cmdclass = { }
ext_modules = [ ]

conf = {'CXXFLAGS' : [], 'LDFLAGS' : []}

if USE_QCAS:
  include_dirs = ['./qcas','/usr/include/qt4/QtCore','/usr/include/qt4/QtGui','/usr/include/qt4/QtXml','/usr/include/qt4','./qcas/qt','./qcas/giac','.']
  libraries=['qcas','dl','giac','gmp','QtXml','QtGui','QtCore','pthread' ]
  library_dirs=['./qcas']
else:
  libraries=['giac','csage' ]
  library_dirs=[SAGE_LOCAL+'/lib']
  include_dirs=[SAGE_LOCAL+'/include',SAGE_SRC,SAGE_LOCAL+'/include/csage']


if USE_CYTHON:
    ext_modules+=[Extension(
                   "giacpy",                 # name of extension
                   ["giacpy.pyx"], #  our Cython source
                   libraries=libraries,
                   library_dirs=library_dirs,
                   include_dirs=include_dirs,
                   extra_compile_args=conf["CXXFLAGS"],
                   extra_link_args=conf["LDFLAGS"],
                   language="c++")]
    cmdclass={'build_ext': build_ext}

else:
    ext_modules+=[Extension(
                   "giacpy",                 # name of extension
                   ["giacpy.cpp"], #  the cpp file already created by Cython
                   library_dirs=library_dirs,
                   libraries=libraries,
                   include_dirs=include_dirs,
                   extra_compile_args=conf["CXXFLAGS"],
                   extra_link_args=conf["LDFLAGS"],
                   language="c++")]

setup(


    name='giacpy',
    version='0.4', 
    description='A Cython frontend to the c++ library giac. (Computer Algebra System)',
    author='Frederic Han',
    author_email="han@math.jussieu.fr",
    url='http://www.math.jussieu.fr/~han/xcas/giacpy/',
    long_description=open('README.txt').read(),
    license='GPLv2 or above',
    ext_modules=ext_modules,
    cmdclass=cmdclass
    )



