#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "int_double14.2.h"

/*
Compile with

g++ integMh.cpp -ointegMh -O2 -frounding-math -fomit-frame-pointer -finline-functions -mfpmath=387 -I$CRDIR -L$CRDIR -lcrlibm 

*/

typedef int_double simpfunc(int_complex);
typedef int_double func(int_double,long);

int_double Mhddbou(int_complex s)
/* return 1.22*10^7 *2^{Re s}/|s|^6*/
/* upper bound on |d^2/ds^2 Mh(s)| for |s+4|\geq 5 */
{
  int_double res = 1.0431, res2 = 12200000.0;
  
  if(mod(s+4).left>=5) {
    res2 *= pow((int_double) 2.0,s.real);
    res2 /= pow(norm(s),3);
    if(-res2.right < -res.right)
      res = res2;
  }
  
  return res;
}

int_complex Mh(int_complex s, long l)
{
  int_complex sum, prod, term, clerr;
  int_double s2k, rhol, errterm;
  long k;

  sum.real=0.0; sum.imag=0.0;
  prod = s*(s+1)*(s+2);
  for(k=3, s2k=8.0; k<=l; k++) {
    prod *= (s+k);
    term = s2k;
    term *= k*(k-1)*(k-2)*(k*k-3*k+4);
    term /= prod;
    if(k<l) {
      sum += term;
      s2k *= -2.0;
    } else {
      rhol = 2*(l+1)*(l+1);
      rhol /= l*(l-3)*mod(s+l+1);
      errterm = mod(term)/(1-rhol);
      clerr.real.left = errterm.right;
      clerr.real.right = errterm.right;
      clerr.imag.left = errterm.right;
      clerr.imag.right = errterm.right;
      sum+=clerr;
    }
  }

  return sum*exp((int_double) 1.5)*pow(2,s);
}

int_double aMh(int_double x, long l)
{
  int_complex s;
  
  s.real=0; s.imag=x;
  return mod(Mh(s,l));
}

int_double integ(func f, long a, long b, long iter, long l)
{
  int_double step, x0, x1, xint, sum=0.0, res;
  long j;

  step = ((int_double) b-a)/iter;
  for(j=0, x0=a, x1=a+step; j<iter; j++) {
    xint.left  = x0.left;
    xint.right = x1.right;
    res = f(xint,l);
    /*   if(!j)
	 printf("[%g,%g] [%g,%g] %ld\n",xint.left,-xint.right,res.left,-res.right,l);*/
    sum+=res;
    x0=x1; x1=x0+step;
  }

  sum *= step;
  return sum;
}

int_double simplinteg(simpfunc f, long a, long b, long iter)
{
  int_double step, x0, x1, xint, sum=0.0, res;
  long j;

  step = ((int_double) b-a)/iter;
  for(j=0, x0=a; j<iter; j++) {
    x1 = a + (j+1)*step;
    xint.left  = x0.left;
    xint.right = x1.right;
    res = f(xint);
    /*   if(!j)
	 printf("[%g,%g] [%g,%g]\n",xint.left,-xint.right,res.left,-res.right);*/
    sum+=res;
    x0=x1; 
  }

  sum *= step;
  return sum;
}

int_double midpinteg(func f,  long a, long b, long iter, long l)
{
  int_double halfstep, x, sum=0.0, res;
  long j;

  halfstep = ((int_double) b-a)/(2*iter);
  for(j=0; j<iter; j++) {
    x = a + (2*j+1)*halfstep;
    res = f(x,l);
    /*    if(!j)
	  printf("[%g,%g] [%g,%g] %ld\n",x.left,-x.right,res.left,-res.right,l);*/
    sum+=res;
  }

  sum *= 2*halfstep;
  return sum;
}

int main(int argc, char *argv[])
{
  long a,b,n,r,r0,k,k0;
  double tol,tol0;
  int_double sum,err,res;
  int phew1, phew2;
  
  _fpu_rndd();
     
  if(argc<3) {
    a=4;
    b=1000;
    tol0=0.000001;
    r0=100000;
    k0=20;
  } else {
    a=atol(argv[1]);
    b=atol(argv[2]);
    if(argc<4)
      tol0=0.000001;
    else 
      tol0=atof(argv[3]);
    if(argc<5) 
      r0=1000000;
    else
      r0=atol(argv[4]);
    if(argc<6) 
      k0=10;
    else
      k0=atol(argv[5]);
  }

  sum=0.0;
  for(n=a; n<b; n++) {
    r=r0/2; tol=tol0; k=k0;
    do {
      r*=2; k++;
      err = simplinteg(Mhddbou,n,n+1,r);
      res = integ(aMh,n,n+1,r,k);
      err /= 24; err /= r*r;
      /*      printf("%ld %.8g %.8g\n",r,-err.right,tol0);*/
      phew1 = (-err.right)<=tol0;
      phew2 = (-res.right)-res.left<=tol0;
    } while(!phew1 && !phew2);
    
    if(phew1) {
      printf("Error of |Mh(t)| from %ld to %ld: O^*(%.8g)\n",n,n+1,-err.right);
      err.left=err.right;
      res = midpinteg(aMh,n,n+1,r,k);
      /*      printf("Midpoint approx to |Mh(t)| from %ld to %ld: [%.8g,%.8g]\n",n,n+1,res.left,-res.right);
	      res+= err;*/
    } 
    sum += res;
    printf("Integral of |Mh(t)| from %ld to %ld: [%.8g,%.8g]\n",n,n+1,res.left,-res.right);
    printf("Total integral from %ld to %ld: [%.11g,%.11g]\n",a,n+1,sum.left,-sum.right);
  }
}

