# Chapter "The L2 norm and the large sieve"

def cq(q):
  sum=RBF(0)
  pd = prime_divisors(q)
  for p in pd:
    sum += RBF(log(p)/p)
  return sum
        
import numpy as np
from sympy import sieve
    
c0=RBF(RIF(1.332582275,1.332582276));

def makelogarr(N):
  """returns an array with values of log(n), correct for n square-free"""
  dlogar=np.zeros((N+24), dtype=object)
  for n in [1,7..N]:
    dlogar[n] = log(RBF(n))
    dlogar[n+4] = log(RBF(n+4))
  for d in [2,3,6]:
    dl = RBF(log(d)); Nd=N//d
    for n in [1,7..Nd]:
      dlogar[d*n] = dlogar[n]+dl
      dlogar[d*(n+4)] = dlogar[n+4]+dl
  return dlogar  

print "Sieving..."
muarr = tuple([0]+[m for m in sieve.mobiusrange(1,5000000)])
invphiarr = tuple([0]+[RBF(1/phin) for phin in sieve.totientrange(1,5000000)])
logarr = makelogarr(5000000)

def upLq(q,a,b):
  """what is max L_q(x)-(phi(q)/q)*(log x + c0 + cq(q)) for x in [a,b]?"""
  quot = euler_phi(q)/q
  cqc = cq(q)
  Lq=0; maxdif=0
  for n in [1..b]:
    if muarr[n]!=0 and gcd(n,q)==1:
      Lq += invphiarr[n]        
      if n>=a:
        dif = Lq-RBF(quot*(logarr[n]+c0+cqc))
        if dif.upper()>maxdif:
          maxdif = dif.upper()
    elif n==a:
      dif = Lq-RBF(quot*(log(n)+c0+cqc))
      if dif.upper()>maxdif:
        maxdif = dif.upper() 
  return maxdif

def downLq(q,a,b):
  """what is min L_q(x)-(phi(q)/q)*(log x + c0 + cq(q)) for x in [a,b]?"""
  quot = euler_phi(q)/q
  cqc = cq(q)
  Lq=0; mindif=0
  for n in [1..b]:
    if (muarr[n]!=0 and gcd(n,q)==1):
      if n>=a:
        dif = Lq-RBF(quot*(logarr[n]+c0+cqc))
        if dif.lower()<mindif:
          mindif = dif.lower()
      Lq += invphiarr[n]    
    elif n==b:
      dif = Lq-RBF(quot*(log(n)+c0+cqc))
      if dif.lower()<mindif:
        mindif = dif.lower() 
  return mindif
    
def j(q):
  if q%2==0:
    prod=RBF(21/25)
  else:
    prod=RBF(1)
  pd = prime_divisors(q)
  for p in pd:
    if p!=2:
      sqt = RBF(sqrt(p))
      prod *= RBF((p*sqt+p-sqt-1)/(p*sqt-sqt+1))
  return prod

def upbLq(q,a):
  """what is max L_q(x)-(phi(q)/q)*(log x + c0 + cq(q)) for x in [a,oo)?"""
  b = a; newb = b+1000; maxerr=0;
  while newb>b:
    maxerr = max(upLq(q,b,newb),maxerr); b=newb
    errrat = RBF(RBF(5.9)*j(q)/RBF(maxerr))
    newb = ceil((errrat*errrat).upper())
  return maxerr

def downbLq(q,a):
  """what is min L_q(x)-(phi(q)/q)*(log x + c0 + cq(q)) for x in [a,oo)?"""
  b = a; newb = b+1000; maxerr=0;
  while newb>b:
     maxerr = max(-downLq(q,b,newb),maxerr); b=newb
     errrat = RBF(RBF(5.9)*j(q)/RBF(maxerr))
     newb = ceil((errrat*errrat).lower())
  return -maxerr

print "Preparing tables..."
uparr={}; upbrr={}; upcdownarr={}; downbrr={}
for q in divisors(2*3*5*7*11):
  downbrr[q] = downbLq(q,200)

sic = {}
for q in divisors(2*3*5*7*11):
  sic[q] = c0+cq(q)+(q/euler_phi(q))*RBF(downbrr[q])

kap1 = {}
for q in divisors(3*5*7*11):
  kap1[q] = (euler_phi(q)/q)*c0 + RBF(upbLq(q,2))
for q in divisors(3*5*7*11):
  p=min(prime_divisors(2310*17/(2*q)))
  kap1[2*q] = RBF((euler_phi(2*q)/(2*q))*c0 + RBF(upbLq(2*q,p)))

print "done."

print "Checking inequality for q<=30000r..."

def ditir(q,c):
 phir = RBF(euler_phi(q)/q)
 num = 1 - phir*c
 qp = max(q,100)
 den = phir - RBF(1/(log(qp)+c0))
 return RBF(num/den)

checkme=True

for r2 in divisors(3*5*7*11):
  r=2*r2; D=2310; L=30000
  for m in [1,2..L]:
    if gcd(m,D)==1:
      q=r*m
      dr = ditir(q,sic[r])
      if dr.upper()>RBF(log(200)).lower():
        print "Error found for q = ",q," r = ",r
        checkme = False

print "done."

crosser=2.50637

print "Checking inequality for q>=30000r"
for r2 in divisors(3*5*7*11):
  r=2*r2
  rp = 2310/r; L=30000
  lsid(z) = (rp/euler_phi(rp))*((z+c0)/4+sic[r])*4/5
  rsid(z) = (exp(euler_gamma)+RBF(crosser)/log(log(rp*r*L))^2)*log(z+log(rp))
  ldsid(z)=derivative(lsid(z),z)
  rdsid(z)=derivative(rsid(z),z)  
  zv = log(L*r)
  if RBF(lsid(zv)).lower()<RBF(rsid(zv)).upper() or \
    RBF(ldsid(zv)).lower()<RBF(rdsid(zv)).upper():
    print "Error found at r = ",r,":",RBF(lsid(zv)),RBF(rsid(zv))
    checkme=False

if checkme:
  print "Lemma 1.5: all tests passed."
else:
  print "Lemma 1.5: errors found."

cei=(lambda x,d : N((((RBF(10^d)*RBF(x)).upper()).ceil())/10^d))
flo=(lambda x,d : N((((RBF(10^d)*RBF(x)).lower()).floor())/10^d))

def lowtheta(n,N):
  theta = logarr[2]; 
  if n==1:
    return 0
  for p in [3,5..N]:
    if p in Primes():  
      rat = RBF(theta/p).lower()
      if p>n:
        if p==n+1:
          mintheta=rat
        elif rat<mintheta:
          mintheta=rat
      theta += logarr[p]
    if p==n:
      mintheta = RBF(theta/n).lower()
  rat = RBF(theta/N).lower()
  if rat<mintheta:
    mintheta=rat
  return mintheta;
    
lowth17 = lowtheta(17,10000)
lowth17 = min(flo(lowth17,6),0.995268)    

var('z')
for r in divisors(2310):
    thisls(z) = RBF(lowth17)*z-log(2310/r)
    thisrs(z) = (7/2)*(euler_phi(2310/r)/(2310/r))*exp(euler_gamma) * (log(z)+1/log(z))*((euler_phi(r)/r)*(log(z)-cq(2310)) + RBF(kap1[r])) - c0 - (5/2)*RBF(sic[r])
    thdls(z) = derivative(thisls(z))
    thdrs(z) = derivative(thisrs(z))
    if RBF(thisls(30)).lower()<=RBF(thisrs(30)).upper():
        print "Inequality 0.662865 z - log(2310/r) >= ... fails at z=30 for r=",r
        checkme = False
    elif RBF(thdls(30)).lower()<=RBF(thdrs(30)).upper():
        print "Inequality (derivatives) fails at z=30 for r = ",r
        checkme = False

def rques(q,r,kap1,kap2,eta):
  return (eta+1)*(q/euler_phi(q))*((euler_phi(r)/r)*cq(q)+kap1)-c0-eta*kap2
  
excep=set(); excepr=set()
for r in divisors(2*3*5*7*11):
  q=r
  for p in [13,15..31]:
    if p in Primes():
      if RBF(log(q)).lower()<RBF(rques(q,r,kap1[r],sic[r],5/2)).upper(): 
        excep.add(q); excepr.add(r)
      q*=p    

print "Set of exceptions", excep

kap1plus = {}
for r in excepr:
  if r%5==0:
    if r%7==0:
      kap1plus[r] = RBF((euler_phi(r)/(r))*c0 + RBF(upbLq(r,11)))
    else:
      kap1plus[r] = RBF((euler_phi(r)/(r))*c0 + RBF(upbLq(r,7)))
  elif r!=1:
    kap1plus[r] = RBF((euler_phi(r)/(r))*c0 + RBF(upbLq(r,5)))

nexcep = set(); gexcep = set();
for q in excep:
  if q!=1:
    r=gcd(q,2310)
    if RBF(log(q)).lower()<RBF(rques(q,r,kap1plus[r],sic[r],5/2)).upper():
      nexcep.add(q)
    else:
      gexcep.add(q)

print "Persistent exceptions", nexcep

#finishing the check for the non-persistent exceptions
def ditir(q,c,t):
 phir = RBF(euler_phi(q)/q)
 num = t - phir*c
 qp = max(q,350)
 den = phir - RBF(t/(log(qp)+c0))
 return RBF(num/den)

for q in gexcep:
  r=gcd(q,2310)
  if q%2==0:
    t = 3/2
  elif q%3==0:
    t = 2
  else:
    t = 5/2  
  dr = ditir(q,sic[r],t)
  if dr.upper()>RBF(log(275)).lower():
    print "Error found for q = ",q," R>=275"
    checkme = False

for q in gexcep:
  thisL=0
  if q%2==0:
    t = 3/2
  elif q%3==0:
    t = 2
  else:
    t = 5/2  
  for n in [1..275]:
    if n>=200:
      if thisL.lower()<RBF(t*(1+log(n)/(log(max(360,q))+c0))).upper():
        print "Error found for q =",q," R =",n
	checkme = False
    if gcd(n,q)==1 and moebius(n)!=0:
      thisL += RBF(1/euler_phi(n))

print "One last computation..."
muarr = tuple([0]+[m for m in sieve.mobiusrange(1,34820000)])
invphiarr = tuple([0]+[RBF(1/phin) for phin in sieve.totientrange(1,34820000)])
logarr = makelogarr(34820000)
down48000 = downLq(1,48000,5900*5900)
if down48000 >= -0.001:
  print "err_{1,R} is indeed >= - 0.001 for R>=48000"
else:
  print "max_{R>=48000} err_{1,R} is smaller than stated in the paper."
  checkme = False
  
if checkme:
  print "All tests passed."
else:
  print "Errors found."